/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.common.grid;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationPatternException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.StatusChangeListener;
import eu.unicore.hila.grid.TaskStatus;

/**
 * @author bjoernh
 * 
 *         13.08.2009 10:01:37
 * 
 */
public abstract class BaseJob extends BaseTask implements Job {

    /**
     * @param location
     */
    public BaseJob(Location location) {
	super(location);
    }

    /**
     * @see eu.unicore.hila.Resource#getChildren()
     */
    public List<Resource> getChildren() throws HiLAException {
	List<Resource> children = new ArrayList<Resource>();

	final Location childLocation = this.getLocation()
		.getChildLocation("wd");
	children.add(childLocation.locate());

	return children;
    }

    /**
     * @throws HiLAException
     * @see eu.unicore.hila.grid.Job#getTaskName()
     */
    public String getTaskName() throws HiLAException {
	return this.location.getName();
    }

    /**
     * @throws HiLAException
     * @throws HiLALocationPatternException
     * @see eu.unicore.hila.grid.Task#getSite()
     */
    public Site getSite() throws HiLAException {
	throw new HiLANotImplementedException("Not implemented");
    }

    /**
     * @see eu.unicore.hila.grid.Job#getSubmissionTime()
     */
    @Override
    public Calendar getSubmissionTime() throws HiLAException {
	throw new HiLANotImplementedException("Not implemented");
    }

    /**
     * @throws HiLAException
     * @see eu.unicore.hila.Resource#getMetadata()
     */
    public Metadata getMetadata() throws HiLAException {
	throw new HiLANotImplementedException("Not implemented");
    }

    /**
     * @see eu.unicore.hila.grid.Job#hold()
     */
    @Override
    public void hold() throws HiLAException {
	throw new HiLANotImplementedException(getClass().getName() + " does not implement hold.");
    }
    
    /**
     * @see eu.unicore.hila.grid.Job#resume()
     */
    @Override
    public void resume() throws HiLAException {
	throw new HiLANotImplementedException(getClass().getName() + " does not implement resume");
    }

   /**
     * @throws HiLAException
     * @see eu.unicore.hila.grid.Job#startASync(eu.unicore.hila.grid.StatusChangeListener,
     *      java.io.File[])
     */
   public TaskStatus startASync(StatusChangeListener listener, File... imports) throws HiLAException {
        registerStatusChangeListener(listener);
        startASync(imports);
        return status();
    }

   /**
     * @see eu.unicore.hila.grid.Task#startSync(java.io.File[])
     */
   public TaskStatus startSync(File... files) throws HiLAException {
        startASync(files);
        return block();
    }

}
