/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.common.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Site;

/**
 * @author bjoernh
 * 
 *         13.08.2009 09:59:05
 * 
 */
public abstract class BaseGrid extends BaseResource implements Grid {

    protected final List<Resource> children = new ArrayList<Resource>();

    public BaseGrid(Location _location) {
	super(_location);
    }

    /**
     * @throws HiLAException
     * @see eu.unicore.hila.grid.Grid#getSites()
     */
    public List<Site> getSites() throws HiLAException {
	final List<Site> sites = new ArrayList<Site>();
	final List<Resource> siteRes = this.getChild("sites").getChildren();
	
	for (Resource resource : siteRes) {
	    if (resource instanceof Site) {
		Site site = (Site) resource;
		sites.add(site);
	    }
	}
	return sites;
    }

    /**
     * @throws HiLAException
     * @see eu.unicore.hila.Resource#getChildren()
     */
    public List<Resource> getChildren() throws HiLAException {
	final Location sitesLocation = this.location.getChildLocation("sites");
	return Collections.singletonList(sitesLocation.locate());
    }

    /**
     * @throws HiLAException
     * @see eu.unicore.hila.Resource#getMetadata()
     */
    public Metadata getMetadata() throws HiLAException {
	throw new HiLANotImplementedException("Not implemented");
    }

}
