/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.common.grid;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.ThirdPartyTransfer;

/**
 * @author bjoernh
 * 
 *         13.08.2009 10:11:42
 * 
 */
public abstract class BaseFile extends BaseResource implements File {

    protected String path = null;

   /**
     * @param location
     */
    public BaseFile(Location _location) {
	super(_location);
    }

    /**
     * @see eu.unicore.hila.Resource#getMetadata()
     */
    public Metadata getMetadata() {
	return null;
    }

    /**
     * Don't overwrite by default
     * 
     * @see eu.unicore.hila.grid.File#exportToLocalFile(java.io.File)
     */
    public SimpleTransfer exportToLocalFile(java.io.File localFile)
	    throws HiLAException {
	return exportToLocalFile(localFile, false);
    }

    /**
     * Don't do recursive export by default.
     * 
     * @see eu.unicore.hila.grid.File#exportToLocalFile(java.io.File, boolean)
     */
    @Override
    public SimpleTransfer exportToLocalFile(java.io.File localFile,
	    boolean _overwrite) throws HiLAException {
	return exportToLocalFile(localFile, _overwrite, false);
    }

    /**
     * default implementation of importFromStream not overwriting an existing
     * remote file
     * 
     * @see eu.unicore.hila.grid.File#importAsStream()
     */
    @Override
    public final SimpleTransfer importFromStream(InputStream _is)
	    throws HiLAException {
	return importFromStream(_is, false);
    }

    /**
     * Don't overwrite by default
     * 
     * @see eu.unicore.hila.grid.File#importFromLocalFile(java.io.File)
     */
    public SimpleTransfer importFromLocalFile(java.io.File localFile)
	    throws HiLAException {
	return importFromLocalFile(localFile, false);
    }

    /**
     * Don't do recursive import by default.
     * 
     * @see eu.unicore.hila.grid.File#importFromLocalFile(java.io.File, boolean)
     */
    @Override
    public SimpleTransfer importFromLocalFile(java.io.File localFile,
	    boolean _overwrite) throws HiLAException {
	return importFromLocalFile(localFile, _overwrite, false);
    }

    /**
     * Default implementation, delegates to three single calls for setting each
     * of the flags. Implementations may override this with more efficient code.
     * 
     * @see eu.unicore.hila.grid.File#chmod(boolean, boolean, boolean)
     */
    public void chmod(boolean _readable, boolean _writable, boolean _executable)
	    throws HiLAException {
	this.setIsReadable(_readable);
	this.setIsWritable(_writable);
	this.setIsExecutable(_executable);
    }

    /**
     * default implementation not overwriting possibly existing target file
     * 
     * @see eu.unicore.hila.grid.File#copyTo(eu.unicore.hila.grid.File)
     */
    public void copyTo(File _other) throws HiLAException {
	this.copyTo(_other, false);
    }

    /**
     * default implementation not overwriting possibly existing target file and
     * not doing recursive copy of directory structures
     * 
     * @see eu.unicore.hila.grid.File#copyTo(eu.unicore.hila.grid.File, boolean)
     */
    public void copyTo(File _other, boolean _overwrite) throws HiLAException {
	this.copyTo(_other, _overwrite, false);
    }

    /**
     * default implementation not overwriting possibly existing target file
     * 
     * @see eu.unicore.hila.grid.File#moveTo(eu.unicore.hila.grid.File)
     */
    public void moveTo(File _other) throws HiLAException {
	this.moveTo(_other, false);
    }

    /**
     * default implementation of mkdir, not creating parent directories
     * 
     * @see eu.unicore.hila.grid.File#mkdir()
     */
    @Override
    public final boolean mkdir() throws HiLAException {
	return mkdir(false);
    }

    /**
     * default implementation not overwriting possibly existing target file
     * 
     * @see eu.unicore.hila.grid.File#transfer(eu.unicore.hila.grid.File)
     */
    @Override
    public ThirdPartyTransfer transfer(File _other) throws HiLAException {
	return this.transfer(_other, false);
    }

    /**
     * default implementation not overwriting and not recursive
     * 
     * @see eu.unicore.hila.grid.File#transfer(eu.unicore.hila.grid.File,
     *      boolean)
     */
    public ThirdPartyTransfer transfer(File _other, boolean _overwrite)
	    throws HiLAException {
	return this.transfer(_other, _overwrite, false);
    }

    /**
     * @see eu.unicore.hila.grid.File#delete()
     */
    @Override
    public boolean delete() throws HiLAException {
	return this.delete(false);
    }

   /**
     * @see eu.unicore.hila.grid.File#isRoot()
     */
   public boolean isRoot() {
        return (path.equals("/") || path.equals(""));
    }

   /**
     * @return
     */
   public String getPath() {
        return path;
    }

   /**
     * @see eu.unicore.hila.Resource#getChildren()
     */
   public List<Resource> getChildren() throws HiLAException {
      final List<Resource> children = new ArrayList<Resource>();
        children.addAll(ls());
        return children;
    }
}
