/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid;

import java.util.List;

import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.job.JobDescription;
import eu.unicore.hila.job.model.JobModel;

/**
 * This interface represents something which you can {@link #submit(JobModel)}
 * to. This would typically be a {@link Site}, but can be something else as
 * well. For example, one could submit to {@link Grid} and rely on a broker to
 * assing the {@link Job} to a {@link Site}. Alternatively, one could submit to
 * a broker, if that was a defined {@link Resource}.
 * 
 * @author bjoernh
 * 
 *         14.08.2009 14:39:35
 * 
 */
public interface Submittable extends Resource {
    /**
	 * Submit the given {@link JobModel} to the {@link Submittable}
	 * {@link Resource}.
	 * 
	 * @param _jd
	 * @return
	 * @throws HiLAException
	 * @since 2.3
	 */
	Job submit(JobModel _jd) throws HiLAException;

	/**
	 * Submit the given {@link JobDescription} to the {@link Submittable}
	 * {@link Resource}.
	 * 
	 * @param _jd
	 * @return
	 * @throws HiLAException
	 * @deprecated in favor of the abstract {@link JobModel}
	 */
	Job submit(JobDescription _jd) throws HiLAException;

    /**
     * The {@link List} of {@link Job}s that have been submitted to this
     * {@link Submittable}.
     * 
     * @return
     * @throws HiLAException
     */
    List<Job> getTasks() throws HiLAException;

    /**
     * Retrieve a particular {@link Job} that has been submitted to this
     * {@link Submittable}.
     * 
     * @param _taskId
     * @return
     * @throws HiLAException
     */
    Job getTask(String _taskId) throws HiLAException;
}
