/*********************************************************************************
 * Copyright (c) 2012 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.emi.es;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import org.apache.log4j.Logger;

import eu.emi.emir.client.EMIRClient;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Site;

/**
 * @author bjoernh
 * 
 *         13.01.2012 09:06:35
 * 
 */
@ResourceType(locationStructure = {
        EmiEsImplementationProvider.SCHEME + ":/sites/?",
        EmiEsImplementationProvider.SCHEME + ":/{user}@sites/?" })
public class EmiEsSitesCollection extends BaseResource {

    private static final Logger log = Logger
            .getLogger(EmiEsSitesCollection.class);

    /**
     * @param _location
     */
    public EmiEsSitesCollection(Location _location) {
        super(_location);
    }

    /**
     * @see eu.unicore.hila.Resource#getChildren()
     */
    @Override
    public List<Resource> getChildren() throws HiLAException {
        List<Resource> sites = new ArrayList<Resource>();

        EmiEsProperties props = ((EmiEsGrid) findParentLocationOfType(
                Grid.class, location, Grid.class).locate()).getProperties();
        String emirUrl = props
                .getEmirEndpoint();

        final long startTime = System.currentTimeMillis();
        final long endTime = startTime + 5000;

        EmirSiteDiscovery siteDiscovery = new EmirSiteDiscovery(new EMIRClient(
                emirUrl), props);
        Future<List<Site>> sitesFuture = HiLA.getExecutor().submit(
                siteDiscovery);

        try {
            sites.addAll(sitesFuture.get(5, TimeUnit.SECONDS));
        } catch (InterruptedException e) {
            log.warn("The retrieval of sites from " + emirUrl
                    + " has been interrupted.");
        } catch (ExecutionException e) {
            log.warn(
                    "There was an ExecutionException during the retrieval of sites from "
                            + emirUrl + ".", e);
        } catch (TimeoutException e) {
            log.warn("The retrieval of sites from " + emirUrl + " timed out.");
        }

        return sites;
    }

}
