/*********************************************************************************
 * Copyright (c) 2009-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.emi.es;

import org.apache.log4j.Logger;

import eu.unicore.hila.grid.ID;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * @author bjoernh
 * 
 *         13.08.2009 16:17:43
 * 
 */
public class EmiEsSecurityProperties extends ClientProperties implements
        IClientConfiguration, ID {
    private static final Logger log = Logger
            .getLogger(EmiEsSecurityProperties.class);

    /**
     * 
     */
    public static final String HILA_EMI_ES_BASE = "hila.emi.es";

    /**
     * 
     */
    public static final String TRUSTSTORE = ".truststore";

    /**
     * 
     */
    public static final String TRUSTSTORETYPE = ".truststoretype";

    /**
     * 
     */
    public static final String TRUSTSTOREPASSWORD = ".truststorepassword";

    /**
     * 
     */
    public static final String KEYSTORETYPE = ".keystoretype";

    /**
     * 
     */
    public static final String PASSWORD = ".password";

    /**
     * 
     */
    private static final String KEYPASSWORD = ".keypassword";

    /**
     * 
     */
    public static final String ALIAS = ".alias";

    /**
     * 
     */
    public static final String KEYSTORE = ".keystore";

    private static final String HILAUNICORE6_PROFILE_BASE = HILA_EMI_ES_BASE
            + ".profile";

    private EmiEsProperties properties;

    private String profile;

    private String profileBase;

    /**
     * @param profile
     * 
     */
    public EmiEsSecurityProperties(EmiEsProperties _props, String _profile) {
        super(_props);
        this.properties = _props;
        this.profile = _profile;

        // does not work anymore as of uas-client 1.4.2
        // getETDSettings().setExtendTrustDelegation(true);

        if (log.isDebugEnabled()) {
            log.debug("profile == " + profile);
        }

        if (profile == null) {
            if (log.isDebugEnabled()) {
                log.debug("Using default profile");
            }
            this.profileBase = HILA_EMI_ES_BASE;
        } else {
            this.profileBase = HILAUNICORE6_PROFILE_BASE + "." + profile;
            if (log.isDebugEnabled()) {
                log.debug("Using profile base " + profileBase);
            }
        }
    }

    public EmiEsSecurityProperties(EmiEsProperties _props) {
        this(_props, null);
    }

    /**
     * @see ClientProperties#isSslEnabled()
     */
    @Override
    public boolean isSslEnabled() {
        return true;
    }

    /**
     * @see ClientProperties#clone()
     */
    @Override
    public EmiEsSecurityProperties clone() {
        try {
            EmiEsSecurityProperties u6prop = (EmiEsSecurityProperties) super
                    .clone();
            if (this.profile != null) {
                u6prop.profile = new String(this.profile);
            } else {
                u6prop.profile = null;
            }
            u6prop.properties = (EmiEsProperties) this.properties.clone();
            if (this.profileBase != null) {
                u6prop.profileBase = new String(this.profileBase);
            } else {
                u6prop.profileBase = null;
            }
            return u6prop;
        } catch (Exception e) {
            log.error("Exception in clone()", e);
            return this;
        }
    }

}
