package eu.unicore.hila.grid.bes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

/**
 * @org.apache.xbean.XBean element = "ogsaproperties"
 * 
 * @author bjoernh
 * 
 */
public class BesProperties extends Properties {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2587004056581437922L;

	private static final Logger log = LoggerFactory
			.getLogger(BesProperties.class);

	static final String BASE_BES_PROPERTY = "hila.bes";

	private static final String REGISTRIES_PROPERTY = BASE_BES_PROPERTY
			+ ".registries";

	Properties properties = new Properties();

	private File configBase;

	/**
	 * @param configBase
	 */
	public void setConfigBase(File configBase) {
		this.configBase = configBase;
	}

	/**
	 * @return the configBase
	 */
	public File getConfigBase() {
		return configBase;
	}

	/**
	 * @return
	 */
	public List<String> getRegistryUrls() {
		List<String> registryUrls = new ArrayList<String>();
		String registrieUrlsString = getProperty(REGISTRIES_PROPERTY);
		StringTokenizer tok = new StringTokenizer(registrieUrlsString);
		while (tok.hasMoreTokens()) {
			String registryUrl = tok.nextToken();
			registryUrls.add(registryUrl);
		}

		return registryUrls;
	}

}
