package eu.unicore.hila.grid.bes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseGrid;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;

/**
 * @org.apache.xbean.XBean element = "ogsagrid"
 * 
 * @author bjoernh
 * 
 */
@ResourceType(locationStructure = { BesImplementationProvider.SCHEME + ":/?" })
public class BesGrid extends BaseGrid {

	private static final Logger log = Logger.getLogger(BesGrid.class);

	private static final String CONFIG_KEY = "hila.bes.config";

	private final BesProperties properties;

	/**
	 * @param _location
	 * @throws HiLAException 
	 */
	public BesGrid(Location _location) throws HiLAException {
		super(_location);
		properties = new BesProperties();
		initialize();
	}

	/**
	 * @throws HiLAException 
	 * 
	 */
	private void initialize() throws HiLAException {
		InputStream configStream = null;
		if (System.getProperties().containsKey(CONFIG_KEY)) {
			try {
				File configFile = new File(System.getProperty(CONFIG_KEY));
				configStream = new FileInputStream(configFile);
				properties.load(configStream);
				properties.setConfigBase(configFile.getParentFile()
						.getAbsoluteFile());
			} catch (FileNotFoundException e) {
				throw new HiLAFactoryException(
						"Unable to use configuration from system property "
								+ CONFIG_KEY + ": "
								+ System.getProperty(CONFIG_KEY), e);
			} catch (IOException e) {
				throw new HiLAFactoryException(
						"Unable to use configuration from system property "
								+ CONFIG_KEY + ": "
								+ System.getProperty(CONFIG_KEY), e);
			}

		}

		try {
			File configFile = new File(System.getProperty("user.home")
					+ File.separator + ".hila2" + File.separator
					+ "bes.properties");
			configStream = new FileInputStream(configFile);
			properties.load(configStream);
			properties.setConfigBase(configFile.getParentFile()
					.getAbsoluteFile());
			return;
		} catch (FileNotFoundException e) {
			// this can safely be ignored
		} catch (IOException e) {
			throw new HiLAException(
					"Cannot read configuration file bes.properties from ~/.hila2.",
					e);
		} finally {
			if (configStream != null) {
				try {
					configStream.close();
				} catch (IOException e) {
					log.warn("Unable to close config file input stream", e);
				}
			}
		}

	}

	/**
	 * @param stringURL
	 * @return
	 * @throws MalformedURLException
	 */
	private String getFactoryNameFromEPR(String stringURL)
			throws MalformedURLException {
		return new URL(stringURL).getPath().split("/")[1];
	}

	/**
	 * @return
	 */
	public BesProperties getProperties() {
		return properties;
	}

}
