/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package eu.unicore.hila;

import org.junit.Assert;
import org.junit.Test;

import eu.unicore.hila.exceptions.HiLALocationSyntaxException;

/**
 * @author bjoernh
 * 
 */
public class LocationTest {

	@Test
	public void testGetParent() throws HiLALocationSyntaxException {
		final Location loc1 = new Location(
				"unicore6://bjoernh@sites/GROW/tasks/");
		final Location loc2 = new Location(
				"unicore6://bjoernh@sites/GROW/tasks");

		Location exp1 = new Location("unicore6://bjoernh@sites/GROW/");

		System.out.println(loc1.getParentLocation() + " "
				+ loc2.getParentLocation());
		Assert.assertEquals(loc1.getParentLocation(), loc2.getParentLocation());
		Assert.assertEquals(exp1, loc1.getParentLocation());
		Assert.assertEquals(exp1, loc2.getParentLocation());

	}

	@Test
	public void testGetName() throws HiLALocationSyntaxException {
		final Location loc1 = new Location(
				"unicore6://bjoernh@sites/GROW/tasks");
		final Location loc2 = new Location(
				"unicore6://bjoernh@sites/GROW/tasks/");
		Assert.assertEquals(loc1.getName(), loc2.getName());

		final Location loc3 = new Location("unicore6:/sites/GROW/tasks");
		final Location loc4 = new Location("unicore6:/sites/GROW/tasks/");
		Assert.assertEquals(loc3.getName(), loc4.getName());

		final Location loc5 = new Location("unicore6:/sites");
		Assert.assertEquals("sites", loc5.getName());

		final Location loc6 = new Location("unicore6:/bjoernh@sites");
		final Location loc7 = new Location("unicore6:/bjoernh@sites/");
		Assert.assertEquals(loc6.getName(), loc7.getName());

	}

	@Test
	public void testRelativePath() throws HiLALocationSyntaxException {
		final Location loc1 = new Location("unicore6:/sites/GROW");
		final Location loc2 = new Location("unicore6:/sites/GROW/storages");
		Assert.assertEquals("storages", loc1.relativePath(loc2));
	}

	@Test
	public void testEquals() throws HiLALocationSyntaxException {
		final Location loc1 = new Location("unicore6:/sites/GROW");
		final Location loc2 = new Location("unicore6:/sites/GROW/");
		Assert.assertEquals(loc1, loc2);
		Assert.assertEquals(loc2, loc1);
		Assert.assertEquals(loc1.hashCode(), loc2.hashCode());

		Assert.assertTrue(loc1.equals(loc2));
		Assert.assertTrue(loc2.equals(loc1));
	}

	@Test
	public void testInvalidLocation() {
		try {
			new Location("@^$:/bo@gu@s");
			Assert.fail("Should have thrown an exception");
		} catch (HiLALocationSyntaxException e) {
			// this is a success
		}
	}

	@Test
	public void testGetLocationType() {
		try {
			Class<Resource> locationType = new Location("bogus:/nothing")
					.getLocationType();
			Assert.assertNull(locationType);
		} catch (HiLALocationSyntaxException e) {
			Assert.fail(e.getMessage());
		}
	}

	@Test
	public void testIsAbsolute() {
		try {
			Location absLoc = new Location("unicore6:/sites");
			Location relLoc = new Location("VSGC");

			Assert.assertTrue(absLoc.isAbsolute());
			Assert.assertFalse(relLoc.isAbsolute());
		} catch (HiLALocationSyntaxException e) {
			Assert.fail(e.getMessage());
		}

	}
}
