/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6.security;

import java.util.List;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.ID;
import eu.unicore.hila.grid.unicore6.Unicore6Properties;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;

/**
 * @author bjoernh
 * 
 *         22.07.2010 13:54:54
 * 
 */
public class SimpleProfileConfig implements Config {

    final private Unicore6Properties props;

    /**
     * 
     */
    public SimpleProfileConfig(Unicore6Properties _props) {
	this.props = _props;
    }

    /**
     * @throws HiLANotImplementedException
     * @see eu.unicore.hila.grid.Config#getAllSiteLocations()
     */
    @Override
    public List<Location> getAllSiteLocations()
	    throws HiLANotImplementedException {
	throw new HiLANotImplementedException(
		"getAllSiteLocations not implemented");
    }

    /**
     * @throws HiLAException 
     * @see eu.unicore.hila.grid.Config#getIdForLocation(eu.unicore.hila.Location)
     */
    public ID getIdForLocation(Location location) throws HiLAException {
	return determineSecurityProperties(location);
    }

    /**
     * @see eu.unicore.hila.grid.Config#setIdForLocation(eu.unicore.hila.Location,
     *      eu.unicore.hila.grid.ID)
     */
    public void setIdForLocation(Location location, ID id) {
	// TODO Auto-generated method stub

    }

    /**
     * @param props
     * @param location
     * @return
     * @throws HiLAException
     */
    private Unicore6SecurityProperties determineSecurityProperties(
	    Location location) throws HiLAException {

	// String profile = new URI(location.toString()).getUserInfo();
	String profile = location.getUser();
	Unicore6SecurityProperties u6secProp = new Unicore6SecurityProperties(
		this.props, profile);

	return u6secProp;
    }

}
