/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.HashMap;
import java.util.Map;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.exceptions.HiLAException;

/**
 * @author bjoernh
 * 
 *         15.03.2010 13:31:05
 * 
 */
@ResourceType(locationStructure = {
	"unicore6:/sites/{site}/storages/{storage}/exports/?",
	"unicore6:/{user}@sites/{site}/storages/{storage}/exports/?",
	"unicore6:/sites/{site}/tasks/{task}/wd/exports/?",
	"unicore6:/{user}@sites/{site}/tasks/{task}/wd/exports/?",
	"unicore6:/storages/{storage}/exports/?",
	"unicore6:/{user}@storages/{storage}/exports/?" })
public class Unicore6ExportsCollection extends LocalTasksCollection implements
	Resource {

    private static final Map<Location, Unicore6ExportsCollection> exportsMap = new HashMap<Location, Unicore6ExportsCollection>();

    /**
     * @param location
     */
    private Unicore6ExportsCollection(Location location) {
	super(location);
    }

    public static synchronized Unicore6ExportsCollection locate(
	    Location _location, Object... extraInformation)
	    throws HiLAException {
	if (exportsMap.containsKey(_location)) {
	    return exportsMap.get(_location);
	} else {
	    final Unicore6ExportsCollection exportsCollection = new Unicore6ExportsCollection(
		    _location);
	    exportsMap.put(_location, exportsCollection);
	    return exportsCollection;
	}
    }

}
