/*********************************************************************************
 * Copyright (c) 2009-2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.unicore6;

import java.util.List;
import java.util.concurrent.Callable;

import javax.xml.namespace.QName;

import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * An internal helper class of the UNICORE 6 implementation. It is designed as a
 * callable in order to allow parallel queries to multiple registries. Also,
 * timeouts may be used in order to cover for not responding sites or dropped
 * network connections.
 * 
 * @author bjoernh
 * 
 *         30.09.2009 14:58:01
 * 
 */
class GetServicesFromRegistry implements Callable<List<EndpointReferenceType>> {

    private String registryURL = null;
    private IClientConfiguration security;
    final private QName portType;

    /**
     * @param _portType
     * 
     */
    public GetServicesFromRegistry(String _registryURL,
            IClientConfiguration secProps, QName _portType) {
	this.registryURL = _registryURL;
	this.security = secProps;
	this.portType = _portType;
    }

    /**
     * @see java.util.concurrent.Callable#call()
     */
    public List<EndpointReferenceType> call() throws Exception {
	final EndpointReferenceType registryEpr = EndpointReferenceType.Factory
		.newInstance();
	registryEpr.addNewAddress().setStringValue(registryURL);
	final RegistryClient registry = new RegistryClient(registryURL,
		registryEpr, security);

	List<EndpointReferenceType> tsfEprs = registry
		.listAccessibleServices(portType);

	return tsfEprs;
    }

}
