/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         17.03.2010 11:18:37
 * 
 */
public class Transfer extends ShellCommandBase implements ShellCommand {
    private static final Logger log = Logger.getLogger(Transfer.class);

    /**
     * 
     */
    public Transfer() {
	super();
	inializeOptions();
    }

    /**
     * 
     */
    private void inializeOptions() {
	options.addOption(OptionConstants.FORCE);
	options.addOption(OptionConstants.HELP);
	options.addOption(OptionConstants.RECURSIVE);
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	try {
	    CommandLine cmdline = parser.parse(options, cmdArgs);
	    if (cmdline.hasOption(OptionConstants.HELP.getArgName())) {
		printHelp(ctx);
		return;
	    }

	    if (cmdline.getArgList().size() == 3) {
		String srcString = (String) cmdline.getArgList().get(1);
		String dstString = (String) cmdline.getArgList().get(2);

		Location srcLoc = new Location(srcString);
		if (!srcLoc.isLocationOfType(File.class)) {
		    srcLoc = ctx.getCurrentLocation().getChildLocation(
			    srcString);
		}
		if (!srcLoc.isLocationOfType(File.class)) {
		    log.error(srcString + " is not a File location.");
		}
		File srcFile = (File) srcLoc.locate();

		Location dstLoc = new Location(dstString);
		if (!dstLoc.isLocationOfType(File.class)) {
		    dstLoc = ctx.getCurrentLocation().getChildLocation(
			    dstString);
		}
		if (!dstLoc.isLocationOfType(File.class)) {
		    log.error(dstString + " is not a File location.");
		}
		File dstFile = (File) dstLoc.locate();

		srcFile.transfer(dstFile, cmdline
			.hasOption(OptionConstants.FORCE.getArgName()), cmdline
			.hasOption(OptionConstants.RECURSIVE.getArgName()));

	    } else {
		log.error("Need exactly two arguments.");
	    }
	} catch (ParseException e) {

	}
    }
}
