/*********************************************************************************
 * Copyright (c) 2010 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.shell.commands;

import java.util.List;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;

/**
 * @author bjoernh
 * 
 *         12.03.2010 14:16:40
 * 
 */
public class Rm extends ShellCommandBase implements ShellCommand {
    private static final Logger log = Logger.getLogger(Rm.class);

    /**
     * 
     */
    public Rm() {
	initializeOptions();
    }

    /**
     * 
     */
    private void initializeOptions() {
	options.addOption(OptionConstants.RECURSIVE);
	options.addOption(OptionConstants.HELP);
    }

    /**
     * @see eu.unicore.hila.shell.commands.ShellCommandBase#execute(java.lang.String[],
     *      eu.unicore.hila.shell.ShellContext)
     */
    @Override
    public void execute(String[] cmdArgs, ShellContext ctx)
	    throws HiLAException {
	CommandLine cmdLine;
	try {
	    cmdLine = parser.parse(options, cmdArgs);
	} catch (ParseException e) {
	    throw new HiLAException("Unable to parse command line.");
	}
	
	if(cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
	    printHelp(ctx);
	    return;
	}

	List<String> argList = cmdLine.getArgList();
	argList.remove(0);

	for (String fileStr : argList) {
	    String fileLocStr = fileStr;
	    // make qualified location
	    Location fileLoc = new Location(fileLocStr);
	    if (!fileLoc.isLocationOfType(File.class)) {
		fileLoc = ctx.getCurrentLocation().getChildLocation(fileLocStr);
	    }
	    if (!fileLoc.isLocationOfType(File.class)) {
		log
			.error(fileLocStr
				+ " is not a valid relative or absolute File location.");
		continue;
	    }
	    File file = (File) fileLoc.locate();
	    file.delete(cmdLine.hasOption(OptionConstants.RECURSIVE
		    .getArgName()));
	}
    }
}
