/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.job.model;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.CreationFlagEnumeration.Enum;

/**
 * @author bjoernh
 *
 * 27.06.2011 16:51:15
 *
 */
public class StageIn {
    
    

    private final String fileName;
    private final String sourceURI;
    private final String fileSystemName;
    private final Enum creationFlag;
    private final boolean deleteOnTermination;

    /**
     * @param fileName
     * @param sourceURI
     * @param fileSystemName
     * @param creationFlag
     * @param deleteOnTermination
     */
    public StageIn(String fileName, String sourceURI, String fileSystemName,
	    Enum creationFlag, boolean deleteOnTermination) {
	this.fileName = fileName;
	this.sourceURI = sourceURI;
	this.fileSystemName = fileSystemName;
	this.creationFlag = creationFlag;
	this.deleteOnTermination = deleteOnTermination;
    }

    /**
     * @return the fileName
     */
    public String getFileName() {
	return fileName;
    }

    /**
     * @return the sourceURI
     */
    public String getSourceURI() {
        return sourceURI;
    }

    /**
     * @return the fileSystemName
     */
    public String getFileSystemName() {
        return fileSystemName;
    }

    /**
     * @return the creationFlag
     */
    public Enum getCreationFlag() {
        return creationFlag;
    }

    /**
     * @return the deleteOnTermination
     */
    public boolean isDeleteOnTermination() {
        return deleteOnTermination;
    }

}
