/*********************************************************************************
 * Copyright (c) 2012 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.job.jsdl;

import junit.framework.Assert;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionType;
import org.junit.BeforeClass;
import org.junit.Test;

import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.MappingFactorySpi;
import eu.unicore.hila.job.spi.NativeToModel;
import eu.unicore.hila.job.spi.NoSuchMappingException;

/**
 * @author bjoernh
 *
 * 15.03.2012 13:29:35
 *
 */
public class JSDLtoModelTest {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * Test method for {@link eu.unicore.hila.job.jsdl.JSDLtoModel#getModel()}.
	 * 
	 * @throws NoSuchMappingException
	 */
	@Test
	public void testGetModelNoResources() throws NoSuchMappingException {
		JobDefinitionDocument jd = JobDefinitionDocument.Factory.newInstance();
		JobDescriptionType jDescr = jd.addNewJobDefinition()
				.addNewJobDescription();
		ApplicationType app = jDescr.addNewApplication();
		app.setApplicationName("Date");
		app.setApplicationVersion("1.0");

		MappingFactorySpi mf = MappingFactory.getMapping("jsdl");
		NativeToModel m2n = mf.createNativeToModelMapping(jd);
		JobModel model = m2n.getModel();
		Assert.assertNull(model.getResources());
		Assert.assertEquals("Date", model.getApplicationName());
		Assert.assertEquals("1.0", model.getApplicationVersion());
	}

}
