/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.job.emi;

import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.spi.MappingFactorySpi;
import eu.unicore.hila.job.spi.ModelToNative;
import eu.unicore.hila.job.spi.NativeToModel;

/**
 * @author bjoernh
 *
 * 21.12.2011 16:53:14
 *
 */
public class AdlMappingFactory implements MappingFactorySpi {

   /**
    * 
    */
   public static final String EMI_ADL_MAPPING = "emi-adl";

   /**
    * @see eu.unicore.hila.job.spi.MappingFactorySpi#getFormatName()
    */
   @Override
   public String getFormatName() {
      return EMI_ADL_MAPPING;
   }

   /**
    * @see eu.unicore.hila.job.spi.MappingFactorySpi#createModelToNativeMapping(eu.unicore.hila.job.model.JobModel)
    */
   @Override
   public ModelToNative createModelToNativeMapping(JobModel _jobModel) {
      return new ModelToEmiAdl(_jobModel);
   }

   /**
    * @see eu.unicore.hila.job.spi.MappingFactorySpi#createNativeToModelMapping(java.lang.Object)
    */
   @Override
   public NativeToModel createNativeToModelMapping(Object _native) {
      return new EmiAdlToModel(_native);
   }

}
