/*********************************************************************************
 * Copyright (c) 2012 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.common.grid;

import java.util.List;
import java.util.UUID;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.TaskStatus;

/**
 * @author bjoernh
 *
 * 20.06.2012 16:14:29
 *
 */
public class DummyTask extends BaseTask {

	private long deadline;
	private String uuid;

	/**
	 * @param i
	 * @param location
	 * @throws HiLALocationSyntaxException
	 */
	public DummyTask(long i) throws HiLALocationSyntaxException {
		super(new Location("dummy:/"));
		this.deadline = System.currentTimeMillis() + i;
		this.uuid = UUID.randomUUID().toString();
		setCurrentState(TaskStatus.RUNNING);
	}

	/**
	 * @see eu.unicore.hila.grid.Task#abort()
	 */
	@Override
	public void abort() throws HiLAException {
		setCurrentState(TaskStatus.ABORTED);
	}

	/**
	 * @see eu.unicore.hila.grid.Task#getId()
	 */
	@Override
	public String getId() throws HiLAException {
		return uuid;
	}

	/**
	 * @see eu.unicore.hila.Resource#getChildren()
	 */
	@Override
	public List<Resource> getChildren() throws HiLAException {
		return null;
	}

	/**
	 * @see eu.unicore.hila.common.grid.BaseTask#status()
	 */
	@Override
	public TaskStatus status() throws HiLAException {
		TaskStatus current = super.status();
		if (current.equals(TaskStatus.RUNNING)) {
			if (deadline <= System.currentTimeMillis()) {
				setCurrentState(TaskStatus.SUCCESSFUL);
			}
		}
		return super.status();
	}

}
