/*********************************************************************************
 * Copyright (c) 2012 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
package eu.unicore.hila.grid.emi.es;

import java.util.List;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.Config;
import eu.unicore.hila.grid.ID;

/**
 * @author bjoernh
 * 
 *         13.01.2012 15:11:24
 * 
 */
public class EmiEsConfig implements Config {

   private final EmiEsProperties properties;

   /**
    * @param _emiEsProperties
    */
   public EmiEsConfig(EmiEsProperties _emiEsProperties) {
      this.properties = _emiEsProperties;
   }

   /**
    * @see eu.unicore.hila.grid.Config#getAllSiteLocations()
    */
   @Override
   public List<Location> getAllSiteLocations()
         throws HiLANotImplementedException {
      throw new HiLANotImplementedException(
            "EMI ES uses fixed site configuration.");
   }

   /**
    * @see eu.unicore.hila.grid.Config#getIdForLocation(eu.unicore.hila.Location)
    */
   @Override
   public ID getIdForLocation(Location _location) throws HiLAException {
      return new EmiEsSecurityProperties(this.properties);
   }

   /**
    * @see eu.unicore.hila.grid.Config#setIdForLocation(eu.unicore.hila.Location,
    *      eu.unicore.hila.grid.ID)
    */
   @Override
   public void setIdForLocation(Location _location, ID _id) {
      // TODO
   }

}
