/*
 * Copyright (c) Members of the EMI Collaboration. 2010-2012.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0 
 */
package org.glite.sts.authn;

import java.security.cert.X509Certificate;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.opensaml.soap.soap11.Envelope;
import org.springframework.webflow.execution.RequestContext;

import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.EventIds;
import net.shibboleth.idp.profile.ProfileRequestContext;

/**
 * An authentication stage that extracts an X.509 proxy certificate from the WSS token attached to a SOAP message.
 * As should be obvious, this assumes that the inbound message is a SOAP {@link Envelope}.
 */
@Events({
    @Event(id = EventIds.PROCEED_EVENT_ID)})
public class ExctractX509ProxyCertificateFromWssToken extends AbstractAuthenticationAction {
    
    /** {@inheritDoc} */
    protected org.springframework.webflow.execution.Event doExecute(@Nonnull final HttpServletRequest httpRequest,
            @Nonnull final HttpServletResponse httpResponse, @Nonnull final RequestContext springRequestContext,
            @Nonnull final ProfileRequestContext profileRequestContext,
            @Nonnull final AuthenticationRequestContext authenticationContext) throws AuthenticationException {

        final Envelope envelope = (Envelope) profileRequestContext.getInboundMessageContext().getMessage();
        
        X509Certificate[] proxyChain = getX509ProxyCertificateChain(envelope);

        authenticationContext.getSubcontext(X509ProxyCertificateContext.class, true).setCertificate(proxyChain);

        return ActionSupport.buildProceedEvent(this);
    }
    
    /**
     * Extracts the {@link X509Certificate[]} from the given {@link Envelope}.
     * 
     * @param message the message from which the token should be extracted
     * 
     * @return the extracted token
     */
    private X509Certificate[] getX509ProxyCertificateChain(Envelope message) {
        //TODO: get the chain from the envelope (use canl)
        X509Certificate[] proxyChain = null;
        return proxyChain;
    }

}
