package org.glite.pseudo.ui.client.message;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.glite.pseudo.common.pki.Certificate;
import org.glite.pseudo.ui.client.PseudoServiceClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CertResponseTest {
  
	/** Logging */
	private static Logger log = LoggerFactory.getLogger(CertResponseTest.class);
	
	private static final String TEST_CERT_RESPONSE_FILE = "src/test/resources/certResponse.xml";
	
	private static final String TEST_CERT_PEM = "-----BEGIN CERTIFICATE-----\n"
		+ "MIIEDDCCAvSgAwIBAgIJAJcVbP5Uc9FdMA0GCSqGSIb3DQEBBQUAMGExCzAJBgNV\n"
		+ "BAYTAkVVMREwDwYDVQQIEwhTY2hlbmdlbjENMAsGA1UEBxMEQ2l0eTEVMBMGA1UE\n"
		+ "ChMMT3JnYW5pemF0aW9uMRkwFwYDVQQDExB0ZXN0LWNlcnRpZmljYXRlMB4XDTEx\n"
		+ "MTEwNzA5MTM0MFoXDTIxMTEwNDA5MTM0MFowYTELMAkGA1UEBhMCRVUxETAPBgNV\n"
		+ "BAgTCFNjaGVuZ2VuMQ0wCwYDVQQHEwRDaXR5MRUwEwYDVQQKEwxPcmdhbml6YXRp\n"
		+ "b24xGTAXBgNVBAMTEHRlc3QtY2VydGlmaWNhdGUwggEiMA0GCSqGSIb3DQEBAQUA\n"
		+ "A4IBDwAwggEKAoIBAQC9DbLiBPRAM1fLwPyoLwy+l0A4CxXYNNQqfFhRcQIo4V+V\n"
		+ "WdW87v2dX59ArnL+U84R6oCikpNYScoYpNnaDcIe1LNNGLrZZZ50CGjAaSwxw4Yy\n"
		+ "FjlasD4wmpSciY/Z+DV4PGvbPvJc/SRfccSuuvKRR44EkLC5AXVOxBT43GX8xHCz\n"
		+ "nKDg9chnPQdfUDtgcLXKv8OpG8Y3uuvtHkCTScjJZxHfd20AivnxTpJQBgjkzVBn\n"
		+ "+9OuxzyMUZRLRM0o+gVWjEbyHb6K1dBeKW32NzxeeqMnnVbgs8OFyZ7JCbCrrqO0\n"
		+ "OrIFb7vyOiQnmKm6P0sy0GjRUSd6ZmoN3cvcZwh7AgMBAAGjgcYwgcMwHQYDVR0O\n"
		+ "BBYEFA4Ke2+yR9j5Yk9MGfqiVUKgA0x0MIGTBgNVHSMEgYswgYiAFA4Ke2+yR9j5\n"
		+ "Yk9MGfqiVUKgA0x0oWWkYzBhMQswCQYDVQQGEwJFVTERMA8GA1UECBMIU2NoZW5n\n"
		+ "ZW4xDTALBgNVBAcTBENpdHkxFTATBgNVBAoTDE9yZ2FuaXphdGlvbjEZMBcGA1UE\n"
		+ "AxMQdGVzdC1jZXJ0aWZpY2F0ZYIJAJcVbP5Uc9FdMAwGA1UdEwQFMAMBAf8wDQYJ\n"
		+ "KoZIhvcNAQEFBQADggEBAFiHiAEoD9/jh/vXriaQbNjdRWzu/KYy8avWbcY3Y7H8\n"
		+ "zEaLKJV7BilwLvF1A5jzjyi2ekHZi6KXq2lsvKe9DCqePgsoS6Avi4uH16oPq8qh\n"
		+ "/prGGUgXXJI6+/U17yNCgAc04SR9IrQAbx8+NmntNP00A+bI7DYQupq7zRRDVoKn\n"
		+ "K9a2yWBg00h7yED/mq4ldPYxZLulzE5BHXf7MehlFMs62/j31k2Ay7BWMyuU8G08\n"
		+ "AjMhw2DIIu3yrItMizFK2rHiRzXAiMrPa/0pXkISdz1Zjsczo8a8EhCZxSswEeYm\n"
		+ "NyvEnxcia/hlJwMTpJDocrXYJ2XOpcCl2l/GijUbKfU=\n"
		+ "-----END CERTIFICATE-----";
	
	@Test
	public void initializeByFile() {
		CertResponse certResponse = new CertResponse();
		try {
			certResponse.parseStream(new FileInputStream(TEST_CERT_RESPONSE_FILE));
		} catch (FileNotFoundException e) {
			log.error("Could not find the file " + TEST_CERT_RESPONSE_FILE, e);
		} catch (IOException e) {
			log.error("Error while reading the file " + TEST_CERT_RESPONSE_FILE, e);
		}
		Assert.assertEquals(certResponse.getStatus(), "Success");
		try {
			Certificate certificate = certResponse.getCertificate();
			Assert.assertEquals(certificate.getPEM().trim(), TEST_CERT_PEM);
			Assert.assertEquals(certificate.getCertificate().getSubjectDN().toString(), 
					"C=EU,ST=Schengen,L=City,O=Organization,CN=test-certificate");
		} catch (IOException e) {
			log.error("Could not encode the certificate to PEM", e);
		} catch (PseudoServiceClientException e) {
			log.error("Could not get the certificate from the response message");
		}
	}
}
