package org.glite.pseudo.ui.client.message;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

import org.glite.pseudo.common.pki.CertificateExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CertInfoResponseTest {
	
	/** Logging */
	private static Logger log = LoggerFactory.getLogger(CertInfoResponseTest.class);
	
	private static final String TEST_CERT_INFO_RESPONSE_FILE = "src/test/resources/certInfoResponse.xml";
	
	@Test
	public void initializeByFile() {
		CertInfoResponse certInfo = new CertInfoResponse();
		try {
			certInfo.parseStream(new FileInputStream(TEST_CERT_INFO_RESPONSE_FILE));
		} catch (FileNotFoundException e) {
			log.error("Could not find the file " + TEST_CERT_INFO_RESPONSE_FILE, e);
		} catch (IOException e) {
			log.error("Error while reading the file " + TEST_CERT_INFO_RESPONSE_FILE, e);
		}
		Assert.assertEquals(certInfo.getAuthorizationToken(), "c01117d5d1ffa5b3a4f82aa7b5a5cb93b3b1c39ea6ef2d6a9c85ff25c4313547");
		Assert.assertEquals(certInfo.getServiceEndpoint(), "https://pseudoservice.example.com:8443/pseudo/certificate");
		Assert.assertEquals(certInfo.getStatus(), "Success");
		List<CertificateExtension> certExtensions = certInfo.getCertificateExtensions();
		CertificateExtension extension = certExtensions.get(0);
		Assert.assertEquals(extension.getName(), "ExtendedKeyUsage");
		Assert.assertEquals(extension.getValue(), "ClientAuth");
		Assert.assertEquals(extension.getOID().toString(), "2.5.29.37");
		extension = certExtensions.get(1);
		Assert.assertEquals(extension.getName(), "KeyUsage");
		Assert.assertEquals(extension.getValue(), "DigitalSignature,KeyEncipherment");
		Assert.assertEquals(extension.getOID().toString(), "2.5.29.15");
		extension = certExtensions.get(2);
		Assert.assertEquals(extension.getName(), "CertificatePolicies");
		Assert.assertEquals(extension.getValue(), "2.16.756.1.2.6.4.1.0");
		Assert.assertEquals(extension.getOID().toString(), "2.5.29.32");
	}
}
