/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.ui;

/**
 * <p>
 * Version information for the pseudonymity service client tool.
 * </p>
 */
public class PseudoClientVersion {

    /** Major version number */
    public static final int MAJOR = 1;

    /** Minor version number */
    public static final int MINOR = 1;

    /** Revision version number */
    public static final int REVISION = 1;

    /** Build number */
    public static final int BUILD = 0;

    /** Copyright */
    public static final String COPYRIGHT = "Copyright (c) 2011. Members of the EMI Collaboration";

    /**
     * Prevents instantiation
     */
    private PseudoClientVersion() {
    }

    /**
     * <p>
     * Gets the version information as <code>String</code>.
     * </p>
     * 
     * @return The version number in format MAJOR.MINOR.REVISION.BUILD
     */
    public static String getVersion() {
        StringBuffer sb = new StringBuffer();
        sb.append(MAJOR).append('.');
        sb.append(MINOR).append('.');
        sb.append(REVISION).append('.');
        sb.append(BUILD);
        return sb.toString();
    }
}
