<!-- 
 $Id: listEvents.jsp,v 1.1.1.1 2008/04/07 15:35:18 mikkonen Exp $
 
 Copyright (c) Members of the EGEE Collaboration. 2004.
 See http://eu-egee.org/partners/ for details on the copyright holders.
 For license conditions see the license file or http://eu-egee.org/license.html
-->

<%@ page import="org.glite.pseudo.server.auditor.AuditEventEntry, org.glite.pseudo.server.util.EventUtil" %>

<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>

<bean:define id="events" name="events" type="AuditEventEntry[]"/>

<center>
   <logic:present name="pseudoQuery">
      <bean:define id="dn" name="pseudoQuery" type="String"/>
      <h3>List of the events for
         <bean:write name="dn"/>
      </h3>
   </logic:present>
   <logic:notPresent name="pseudoQuery">
      <h3>List of the events for the user</h3>  
   </logic:notPresent>
   <table border="1">
      <tr>
         <th>Type</th>
         <th>Message</th>
         <th>Date</th>
      </tr>
      <logic:iterate id="event" collection="<%= events %>">
         <bean:define id="eventType" name="event" property="eventType" type="java.lang.Integer"/>
         <tr>
            <td><%= EventUtil.getEventTypeString(eventType.intValue()) %></td>
            <td>
               <html:link action="/admin/getEventDetails" paramId="eid" paramName="event" paramProperty="id">
                  <bean:write name="event" property="eventMessage"/>
               </html:link>
            </td>
            <td><bean:write name="event" property="eventDate"/></td>
         </tr>
      </logic:iterate>
   </table>
</center>