<!-- 
 $Id: listEventDetails.jsp,v 1.1.1.1 2008/04/07 15:35:18 mikkonen Exp $
 
 Copyright (c) Members of the EGEE Collaboration. 2004.
 See http://eu-egee.org/partners/ for details on the copyright holders.
 For license conditions see the license file or http://eu-egee.org/license.html
-->

<%@ page import="org.glite.pseudo.server.auditor.AuditEventEntry, org.glite.pseudo.server.Constants, org.glite.pseudo.server.util.EventUtil" %>

<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>

<center>
   <logic:present name="event">
      <bean:define id="event" name="event" type="AuditEventEntry"/>
      <bean:define id="eventTypeString" value="<%= EventUtil.getEventTypeString(event.getEventType()) %>"/>
      <bean:define id="eventLevelString" value="<%= EventUtil.getEventLevelString(event.getEventLevel()) %>"/>
      <h3>Event details</h3>
      <table border="1">
         <tr>
            <th>Property</th>
            <th>Value</th>
         </tr>
         <tr>
            <td>EventType</td>
            <td><bean:write name="eventTypeString"/></td>
         </tr>
         <tr>
            <td>EventLevel</td>
            <td><bean:write name="eventLevelString"/></td>
         </tr>
         <tr>
            <td>EventDate</td>
            <td><bean:write name="event" property="eventDate"/></td>
         </tr>
         <tr>
            <td>EventMessage</td>
            <bean:define id="eventMessage" name="event" property="eventMessage" type="String"/>
            <bean:define id="eventMessageDN" value="<%= "" + EventUtil.isValidDN(eventMessage) %>"/>
            <td>
               <logic:equal name="eventMessageDN" value="true">
                  <html:link action="/admin/searchDN" paramId="dnQuery" paramName="eventMessage">
                     <bean:write name="event" property="eventMessage"/>
                  </html:link>
               </logic:equal>
               <logic:equal name="eventMessageDN" value="false">
                  <bean:write name="event" property="eventMessage"/>
               </logic:equal>           
            </td>
         </tr>
         <tr>
            <td>RemoteAddress</td>
            <td><bean:write name="event" property="remoteAddress"/></td>
         </tr>
      </table>
      <bean:define id="author" name="event" property="eventAuthor"/>
      <h3>Author details</h3>
      <table border="1">
         <tr>
            <th>Property</th>
            <th>Value</th>
         </tr>
         <tr>
            <td>Identifier</td>
            <td>
               <html:link action="/admin/getUserEvents" paramId="uid" paramName="author" paramProperty="id">
                  <bean:write name="author" property="identifier"/>
               </html:link>
            </td>
         </tr>
      </table>
   </logic:present>
</center>