/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.util;

import javax.security.auth.x500.X500Principal;

import org.glite.pseudo.server.Constants;
import org.glite.pseudo.server.auditor.event.AuditEvent;

/**
 * This class provides static methods related to <code>AuditEvent</code>s.
 */
public class EventUtil {

    /**
     * Get event type as descriptive string.
     * 
     * @param eventType
     *            event type
     * @return the type as string
     */
    public static String getEventTypeString(int eventType) {
        String result = eventType + ": ";
        switch (eventType) {
        case Constants.AUDIT_LEVEL_PSEUDO_DN_ISSUANCE:
            result = result + "Issued DN";
            break;
        case Constants.AUDIT_LEVEL_CERTIFICATE_REQUEST:
            result = result + "Requested certificate";
            break;
        case Constants.AUDIT_LEVEL_CERTIFICATE_ISSUANCE:
            result = result + "Issued certificate";
            break;
        case Constants.AUDIT_LEVEL_CERTIFICATE_REGISTRATION:
            result = result + "Registered certificate";
            break;
        case Constants.AUDIT_LEVEL_ADMIN_LOGIN:
            result = result + "Admin login";
            break;
        case Constants.AUDIT_LEVEL_ADMIN_LIST_EVENTS:
            result = result + "Admin list events";
            break;
        case Constants.AUDIT_LEVEL_ADMIN_EVENT_DETAILS:
            result = result + "Admin event details";
            break;
        default:
            result = result + "Unknown type";
            break;
        }
        return result;
    }

    /**
     * Get event level as descriptive string.
     * 
     * @param eventLevel
     *            event level
     * @return the level as string
     */
    public static String getEventLevelString(int eventLevel) {
        String result = eventLevel + ": ";
        switch (eventLevel) {
        case AuditEvent.LEVEL_INFO:
            result = result + "INFO";
            break;
        case AuditEvent.LEVEL_WARN:
            result = result + "WARN";
            break;
        case AuditEvent.LEVEL_ERROR:
            result = result + "ERROR";
            break;
        default:
            result = result + "Unknown level";
            break;
        }
        return result;
    }

    /**
     * Checks whether the given certificate subject DN structure is valid.
     * 
     * @param dn
     *            the subject DN
     * @return true if valid, false otherwise.
     */
    public static boolean isValidDN(String dn) {
        try {
            new X500Principal(dn);
            return true;
        } catch (IllegalArgumentException e) {
            return false;
        }
    }

}
