/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.util;

import javax.servlet.http.HttpServletRequest;

import org.glite.pseudo.server.Constants;
import org.glite.pseudo.server.attribute.Attribute;

/**
 * This class provides static util methods related to <code>Attribute</code>s.
 */
public class AttributeUtil {

    /**
     * Parses the remote address from HttpServletRequest and generates a
     * corresponding Attribute.
     * 
     * @param request
     *            the servlet request.
     * @return remote address attribute.
     */
    public static Attribute getRemoteAddressAttribute(HttpServletRequest request) {
        Attribute remoteAddress = new Attribute();
        remoteAddress.setName(Constants.USER_REMOTE_ADDRESS_ATTR_IDENTIFIER);
        remoteAddress.setValue(request.getRemoteAddr());
        return remoteAddress;
    }

    /**
     * Generates a subject DN attribute.
     * 
     * @param dn
     *            subject DN.
     * @return subject DN attribute.
     */
    public static Attribute getSubjectDNAttribute(String dn) {
        Attribute subjectDN = new Attribute();
        subjectDN.setName(Constants.USER_SUBJECT_DN_ATTR_IDENTIFIER);
        subjectDN.setValue(dn);
        return subjectDN;
    }

}
