/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.glite.pseudo.server.Constants;
import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An action for searching using the DN.
 */
public class SearchDNAction extends AbstractAction {

    /** Logging */
    private static final Logger log = LoggerFactory
            .getLogger(SearchDNAction.class);

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.struts.action.AbstractAction#executeAction(org.apache
     * .struts.action.ActionMapping, org.apache.struts.action.ActionForm,
     * javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse)
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        String dnQuery = request.getParameter("dnQuery");
        if (dnQuery != null) {
            dnQuery = dnQuery.trim();
            String sortBy = request.getParameter("sortBy");
            AuditEventEntry[] events = null;
            logEvent(Constants.AUDIT_LEVEL_ADMIN_LIST_EVENTS, dnQuery, request);
            if (sortBy != null && !sortBy.equals("null")) {
                log.debug("Getting events for DN={}, sorted by {}", dnQuery,
                        sortBy);
                events = getAuditDatabaseReader(request).getPseudoEvents(
                        dnQuery, sortBy);
            } else {
                log.debug("Getting events for DN={}", dnQuery);
                events = getAuditDatabaseReader(request).getPseudoEvents(
                        dnQuery);
            }
            request.setAttribute("events", events);
            request.setAttribute("pseudoQuery", dnQuery);
        }

        ActionForward forward = mapping.findForward("list.events");
        ActionRedirect redirect = new ActionRedirect(forward);

        return redirect;
    }

}
