/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.struts.action;

import java.security.cert.X509Certificate;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.glite.pseudo.server.Constants;
import org.glite.pseudo.server.session.AdminSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>
 * An Action for logging in the (admin) user.
 * </p>
 */
public class LoginAction extends Action {

    /** Logging */
    private static final Logger log = LoggerFactory
            .getLogger(LoginAction.class);

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.struts.action.Action#execute(org.apache.struts.action.
     * ActionMapping, org.apache.struts.action.ActionForm,
     * javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse)
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        AdminSession admin = (AdminSession) request.getSession().getAttribute(
                Constants.ADMIN_USER_SESSION_ID);

        if (admin == null) {
            log.debug("Admin user is not logged in yet.");
            X509Certificate[] clientCerts = null;
            clientCerts = (X509Certificate[]) request
                    .getAttribute("javax.servlet.request.X509Certificate");
            if (clientCerts == null || clientCerts.length == 0) {
                throw new ServletException(
                        "No certificate chain found from the HttpServletRequest!");
            }
            try {
                admin = new AdminSession(clientCerts, request);
                request.getSession().setAttribute(
                        Constants.ADMIN_USER_SESSION_ID, admin);
                AbstractAction.logEvent(Constants.AUDIT_LEVEL_ADMIN_LOGIN,
                        "client-cert", request);
                log.info("Admin user authenticated.");
            } catch (Exception e) {
                throw new ServletException(e);
            }
        } else {
            log.debug("Admin user already logged in.");
        }
        ActionForward forward = mapping.findForward("go.home");
        ActionRedirect redirect = new ActionRedirect(forward);

        return redirect;
    }
}
