/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.glite.pseudo.server.auditor.AuditPersonEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>
 * An Action for listing all the users from the audit database.
 * </p>
 */
public class ListUsersAction extends AbstractAction {

    /** Logging */
    private static final Logger log = LoggerFactory
            .getLogger(ListUsersAction.class);

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.struts.action.AbstractAction#executeAction(org.apache
     * .struts.action.ActionMapping, org.apache.struts.action.ActionForm,
     * javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse)
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        log.debug("Getting all the users.");

        AuditPersonEntry[] users = getAuditDatabaseReader(request).getPersons();
        request.setAttribute("users", users);

        ActionForward forward = mapping.findForward("list.users");
        ActionRedirect redirect = new ActionRedirect(forward);

        return redirect;
    }
}
