/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.glite.pseudo.server.Constants;
import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>
 * An Action for getting all the events for specific user.
 * </p>
 */
public class GetUserEventsAction extends AbstractAction {

    /** Logging */
    private static final Logger log = LoggerFactory
            .getLogger(GetUserEventsAction.class);

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.struts.action.AbstractAction#executeAction(org.apache
     * .struts.action.ActionMapping, org.apache.struts.action.ActionForm,
     * javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse)
     */
    protected ActionForward executeAction(ActionMapping mapping,
            ActionForm form, HttpServletRequest request,
            HttpServletResponse response) throws Exception {
        String userIdStr = request.getParameter("uid");
        if (userIdStr != null && !userIdStr.equals("null")) {
            AuditEventEntry[] events = null;
            String sortBy = request.getParameter("sortBy");
            logEvent(Constants.AUDIT_LEVEL_ADMIN_LIST_EVENTS, "for uid="
                    + userIdStr, request);
            if (sortBy != null && !sortBy.equals("null")) {
                log.debug("Getting events for uid={}, sorted by {}", userIdStr,
                        sortBy);
                events = getAuditDatabaseReader(request).getEvents(userIdStr,
                        sortBy);
            } else {
                log.debug("Getting events for uid={}", userIdStr);
                events = getAuditDatabaseReader(request).getEvents(userIdStr);
            }
            request.setAttribute("events", events);
            request.setAttribute("uid", userIdStr);
        }
        ActionForward forward = mapping.findForward("list.events");
        ActionRedirect redirect = new ActionRedirect(forward);
        return redirect;
    }
}
