/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.glite.pseudo.server.Constants;
import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>
 * An Action for getting the details for the specific event.
 * </p>
 */
public class GetEventDetailsAction extends AbstractAction {

    /** Logging */
    private static final Logger log = LoggerFactory
            .getLogger(GetEventDetailsAction.class);

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.struts.action.AbstractAction#executeAction(org.apache
     * .struts.action.ActionMapping, org.apache.struts.action.ActionForm,
     * javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse)
     */
    protected ActionForward executeAction(ActionMapping mapping,
            ActionForm form, HttpServletRequest request,
            HttpServletResponse response) throws Exception {
        String eventIdStr = request.getParameter("eid");
        if (eventIdStr != null && !eventIdStr.equals("null")) {
            AuditEventEntry event = null;
            logEvent(Constants.AUDIT_LEVEL_ADMIN_EVENT_DETAILS, "for eid="
                    + eventIdStr, request);
            log.debug("Getting details for eid={}", eventIdStr);
            event = getAuditDatabaseReader(request).getEvent(eventIdStr);
            if (event != null) {
                request.setAttribute("event", event);
            } else {
                ActionErrors messages = new ActionErrors();
                ActionMessage message = new ActionMessage("invalid.eid");
                messages.add(ActionMessages.GLOBAL_MESSAGE, message);
                saveErrors(request, messages);
            }
        }
        ActionForward forward = mapping.findForward("list.event.details");
        ActionRedirect redirect = new ActionRedirect(forward);
        return redirect;
    }

}