/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.struts;

import java.io.IOException;
import java.io.Serializable;

import javax.security.auth.x500.X500Principal;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import eu.emi.security.authn.x509.impl.X500NameUtils;

/**
 * This action form controls the input from the Pseudonymity Service's
 * administrator interface.
 */
public class PseudoActionForm extends ActionForm implements Serializable {

    /** Serial version UID */
    private static final long serialVersionUID = -8113578796120462301L;

    /** Logging */
    private static final Logger log = LoggerFactory
            .getLogger(PseudoActionForm.class);

    /** The form element containing the DN query */
    private String dnQuery = "";

    /**
     * Constructs a new PseudoActionForm.
     */
    public PseudoActionForm() {
        super();
    }

    /**
     * Gets the DN query element.
     * 
     * @return the DN query element.
     */
    public String getDnQuery() {
        return this.dnQuery;
    }

    /**
     * Sets the DN query element.
     * 
     * @param dn
     *            the new DN query element.
     */
    public void setDnQuery(String dn) {
        this.dnQuery = dn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.apache.struts.action.ActionForm#validate(org.apache.struts.action
     * .ActionMapping, javax.servlet.http.HttpServletRequest)
     */
    public ActionErrors validate(ActionMapping mapping,
            javax.servlet.http.HttpServletRequest request) {
        super.validate(mapping, request);
        if (!this.dnQuery.equals("")) {
            log.debug("Validating dnQuery={}", this.dnQuery);
            X500Principal dn;
			try {
				dn = X500NameUtils.getX500Principal(dnQuery);
			} catch (IOException e) {
				log.debug("Could not convert DN into an X500Principal", e);
				dn = null;
			}
            if (dn == null) {
                ActionMessage message = new ActionMessage("invalid.dn");
                ActionErrors messages = new ActionErrors();
                messages.add(ActionMessages.GLOBAL_MESSAGE, message);
                log.debug("Returning error messages.");
                return messages;
            }
        }
        return null;
    }
}
