/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.standalone;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.glite.pseudo.server.PseudoServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This servlet implements the service shutdown logic.
 * 
 * Imported from org.glite.authz.pap.server.standalone.ShutdownServlet.
 */
public class ShutdownServlet extends HttpServlet {

    /** Serial number */
    private static final long serialVersionUID = 1L;

    /** The logging facility **/ 
    public static final Logger log = LoggerFactory.getLogger(ShutdownServlet.class);

    /** 
     * The name of the HTTP header coming in the shutdown request that contains the
     * shutdown command.
     */
    public static final String SHUTDOWN_COMMAND_HEADER_NAME = "PSEUDO_SHUTDOWN_COMMAND";

    /**
     * The thread that will trigger the shutdown.
     */
    private Thread shutdownCommandThread;

    /**
     * Constructs a new <code>ShutdownServlet</code>.
     * @param shutdownThread, the thread that will shutdown the service upon request
     */
    public ShutdownServlet(Thread shutdownThread) {
        this.shutdownCommandThread = shutdownThread;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

        String papShutdownCommand = null;
        try {
            papShutdownCommand = StandaloneConfiguration.instance().getString("shutdown_command");
        } catch (PseudoServerException e) {
            log.error("Configuration is not initialized!", e);
        }

        log.info("Shutdown request received from {}.", req.getRemoteAddr());

        if (papShutdownCommand == null){

            shutdownCommandThread.start();

        } else {

            String shutdownCommand = req.getHeader(SHUTDOWN_COMMAND_HEADER_NAME);

            if (shutdownCommand != null && shutdownCommand.equals(papShutdownCommand))
                shutdownCommandThread.start();
            else
                log.warn("Shutdown attempted with invalid command string!"); 

        }
    }
}
