/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.session.impl;

import java.util.Date;
import java.util.List;

import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.session.Session;

/**
 * This class provides a simple implementation of the user <code>Session</code>.
 */
public class SessionImpl implements Session {

    /** The corresponding authorization token */
    private String token;

    /** The corresponding distinguished name */
    private String dn;

    /** The expiration time of this session */
    private Date expirationTime;

    /** The user attributes */
    private List<Attribute> attributes;

    /**
     * Constructs a new <code>SessionImpl</code>
     * 
     * @param dn
     *            the distinguished name as <code>String</code>
     * @param token
     *            the authorization token as <code>String</code>
     * @param lifetime
     *            the lifetime in milliseconds
     */
    public SessionImpl(String dn, String token, long lifetime) {
        this.dn = dn;
        this.token = token;
        Date now = new Date();
        this.expirationTime = new Date(now.getTime() + lifetime);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.server.session.Session#getToken()
     */
    public String getToken() {
        return this.token;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.server.session.Session#getDN()
     */
    public String getDN() {
        return this.dn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.server.session.Session#isValid()
     */
    public boolean isValid() {
        Date now = new Date();
        return now.before(this.expirationTime);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.server.session.Session#setAttributes(java.util.List)
     */
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.server.session.Session#getAttributes()
     */
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

}
