/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.session;

/**
 * This interface represents a storage service at the Pseudonymity Service. It
 * is used for storing the user sessions.
 */
public interface StorageService {

    /**
     * Puts a <code>Session</code> into the storage.
     * 
     * @param session
     *            the <code>Session</code> to be stored.
     */
    public void put(Session session);

    /**
     * Removes a <code>Session</code> from the storage.
     * 
     * @param id
     *            the identifier of the <code>Session</code>
     */
    public void remove(String id);

    /**
     * Gets the <code>Session</code> from the storage
     * 
     * @param id
     *            the identifier of the <code>Session</code>
     * @return the corresponding <code>Session</code>
     */
    public Session get(String id);

}
