/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.session;

/**
 * This interface represents a manager for the user sessions at the Pseudonymity
 * Service.
 */
public interface SessionManager {

    /**
     * Creates a new session with the given distinguished name.
     * 
     * @param dn
     *            the DN as <code>String</code>
     * @return a new <code>Session</code>
     */
    public Session createSession(String dn);

    /**
     * Gets the <code>Session</code> corresponding to the given parameters.
     * 
     * @param dn
     *            the DN as <code>String</code>
     * @param token
     *            the authorization token as <code>String</code>
     * @return the corresponding <code>Session</code>
     */
    public Session getSession(String dn, String token);

}
