/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.session;

import java.util.List;

import org.glite.pseudo.server.attribute.Attribute;

/**
 * This interface represents a user session at the Pseudonymity Service.
 */
public interface Session {

    /**
     * Gets the authorization token related to this <code>Session</code>.
     * 
     * @return the authorization token as <code>String</code>
     */
    public String getToken();

    /**
     * Gets the distinguished name of the certificate related to this
     * <code>Session</code>.
     * 
     * @return the DN as as <code>String</code>
     */
    public String getDN();

    /**
     * Checks whether this <code>Session</code> is still valid.
     * 
     * @return <code>true</code> if valid, <code>false</code> otherwise
     */
    public boolean isValid();

    /**
     * Sets the user attributes related to this <code>Session</code>.
     * 
     * @param attributes
     *            the <code>List</code> of the <code>Attribute</code>s
     */
    public void setAttributes(List<Attribute> attributes);

    /**
     * Gets the list of the user attributes related to this <code>Session</code>
     * .
     * 
     * @return the <code>List</code> of the <code>Attribute</code>s
     */
    public List<Attribute> getAttributes();

}
