/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.session;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.util.AttributeUtil;

import eu.emi.security.authn.x509.proxy.ProxyUtils;

/**
 * Simple administrator user session object. Contains certificate subject DN and
 * remote address as attributes (required for auditing).
 */
public class AdminSession {

    /** The subject DN and remote address as Attribute */
    private List<Attribute> m_attributes;

    /**
     * <p>
     * Constructs a new AdminSession.
     * </p>
     * 
     * @param certificates
     *            The client certificate chain
     * @param request
     *            The HTTP request we are processing
     * @throws PseudoServerException
     *             if any errors occur
     */
    public AdminSession(X509Certificate[] certificates,
            HttpServletRequest request) throws PseudoServerException {
        this.m_attributes = new Vector<Attribute>();
        String dn = ProxyUtils.getEndUserCertificate(certificates).getSubjectDN().toString();
        Attribute subjectDN = AttributeUtil.getSubjectDNAttribute(dn);
        this.m_attributes.add(subjectDN);
        Attribute remoteAddress = AttributeUtil
                .getRemoteAddressAttribute(request);
        this.m_attributes.add(remoteAddress);
    }

    /**
     * <p>
     * Gets the list of attributes.
     * </p>
     * 
     * @return The list of attributes
     */
    public List<Attribute> getAttributes() {
        return this.m_attributes;
    }

}
