/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.policy.impl;

import java.util.Collections;
import java.util.List;

import org.glite.pseudo.common.pki.CertificateExtension;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.glite.pseudo.server.policy.CertificatePolicy;

/**
 * NoCertificatePolicy implements a dummy empty certificate policy.
 * 
 * Imported from org.glite.slcs.policy.impl.NoCertificatePolicy
 * 
 * @author Valery Tschopp &lt;tschopp@switch.ch&gt;
 */
public class NoCertificatePolicy implements CertificatePolicy {

    /**
     * Constructs a new <code>NoCertificatePolicy</code>.
     */
    public NoCertificatePolicy() {
        // no op
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.server.policy.CertificatePolicy#isCertificateRequestValid
     * (org.glite.pseudo.common.pki.CertificateRequest, java.util.List)
     */
    public boolean isCertificateRequestValid(CertificateRequest request,
            List<Attribute> attributes) {
        // no checks, always true
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.server.policy.CertificatePolicy#
     * getRequiredCertificateExtensions(java.util.List)
     */
    public List<CertificateExtension> getRequiredCertificateExtensions(
            List<Attribute> attributes) {
        // no required certificate extensions
        return Collections.emptyList();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.glite.pseudo.server.PseudoServerComponent#init(org.glite.pseudo.server
     * .config.PseudoServerConfiguration)
     */
    public void init(PseudoServerConfiguration configuration) {
        // no configuration parameters supported
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.server.PseudoServerComponent#shutdown()
     */
    public void shutdown() {
    }

}
