/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.policy;

import java.util.List;

import org.glite.pseudo.common.pki.CertificateExtension;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.attribute.Attribute;

/**
 * CertificatePolicy interface defines the policy applied to the certificate
 * request.
 * 
 * Imported from org.glite.slcs.policy.CertificatePolicy
 */
public interface CertificatePolicy extends PseudoServerComponent {

    /**
     * Validates a certificate request against the certificate policy.
     * 
     * @param request
     *            The CertificateRequest object to validate.
     * @param attributes
     *            The user attributes perhap's needed to verify user dependent
     *            extension values (SubjectAltName, ...).
     * @return <code>true</code> if and only if the certificate request is
     *         valid.
     * @see org.glite.pseudo.common.pki.CertificateRequest
     */
    public boolean isCertificateRequestValid(CertificateRequest request,
            List<Attribute> attributes);

    /**
     * Returns a List of {@link CertificateExtension}s required by the policy.
     * As some extensions could be parametrized, the list of user's attributes
     * are needed.
     * 
     * @param attributes
     *            The List of user {@link Attribute}s.
     * @return The List of required cerificate extension.
     * @see org.glite.pseudo.common.pki.CertificateExtension
     */
    public List<CertificateExtension> getRequiredCertificateExtensions(
            List<Attribute> attributes);
}
