/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.dn;

import java.util.List;

import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.attribute.Attribute;

/**
 * This interface is used for building the distinguished name (DN) for the
 * certificates according to the user attributes.
 */
public interface DNBuilder extends PseudoServerComponent {

    /**
     * Creates a new DN.
     * 
     * @param attributes
     *            the user attributes
     * @return DN as <code>String</code>
     */
    public String createDN(List<Attribute> attributes);

}
