package org.glite.pseudo.server.caclient.impl;

import org.glite.pseudo.common.util.Util;
import org.glite.pseudo.server.PseudoServerException;
import org.ini4j.Ini;

/**
 * Abstract class for the <code>CAClient</code> and <code>AAClient</code>
 * implementations using SSL.
 */
public class AbstractSSLClient {

    /** Configuration identifier for the service endpoint */
    public static final String ENDPOINT_IDENTIFIER = "Endpoint";

    /** Configuration identifier for the client certificate file */
    public static final String CERT_FILE_IDENTIFIER = "CertificateFile";

    /** Configuration identifier for the private key file */
    public static final String KEY_FILE_IDENTIFIER = "KeyFile";

    /** Configuration identifier for the private key password */
    public static final String KEY_PASSWD_IDENTIFIER = "KeyPasswd";

    /** Configuration identifier for the truststore file */
    public static final String TRUSTSTORE_FILE_IDENTIFIER = "TruststoreFile";

    /** Configuration identifier for the truststore password */
    public static final String TRUSTSTORE_PASSWD_IDENTIFIER = "TruststorePasswd";

    /** Configuration identifier for the boolean for requiring the CRL check */
    public static final String CRL_CHECK_REQUIRED_IDENTIFIER = "RequireCRLCheck";

    /** The service endpoint */
    protected String endpoint;

    /** The full path for the private key file */
    protected String keyFile;

    /** The password for the password decryption */
    protected String keyPasswd;

    /** The full path for the client certificate file */
    protected String certFile;

    /** The full path for the truststore */
    protected String truststoreFile;

    /** The password for the truststore */
    protected String truststorePasswd;

    /** Should the CRL be checked during the server certificate validation */
    protected String crlCheck;

    /**
     * Initializes the associated resources.
     * 
     * @param cfgSection
     *            the related configuration section
     */
    public void init(Ini.Section cfgSection) throws PseudoServerException {
        endpoint = Util.safeTrimOrNullString(cfgSection
                .get(ENDPOINT_IDENTIFIER));
        if (endpoint == null) {
            throw new PseudoServerException("Endpoint URL cannot be empty!");
        }
        keyFile = Util
                .safeTrimOrNullString(cfgSection.get(KEY_FILE_IDENTIFIER));
        keyPasswd = Util.safeTrimOrNullString(cfgSection
                .get(KEY_PASSWD_IDENTIFIER));
        certFile = Util.safeTrimOrNullString(cfgSection
                .get(CERT_FILE_IDENTIFIER));
        truststoreFile = Util.safeTrimOrNullString(cfgSection
                .get(TRUSTSTORE_FILE_IDENTIFIER));
        truststorePasswd = Util.safeTrimOrNullString(cfgSection
                .get(TRUSTSTORE_PASSWD_IDENTIFIER));
        crlCheck = Util.safeTrimOrNullString(cfgSection
                .get(CRL_CHECK_REQUIRED_IDENTIFIER));
    }

    /**
     * Shuts down the associated resources.
     */
    public void shutdown() {
    }

}
