/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.caclient;

import java.security.Principal;

import org.glite.pseudo.common.pki.Certificate;

/**
 * CAResponse is an interface for a generic online CA server response.
 * 
 * Imported from org.glite.slcs.caclient.CAResponse
 * 
 * @author Valery Tschopp <tschopp@switch.ch>
 */
public interface CAResponse {

    /**
     * Gets the Certificate (with its chain) for the given Principal.
     * 
     * @param subject
     *            The Principal (DN).
     * @return The Certificate object.
     * @throws CAClientException
     *             If an error occurs.
     */
    public Certificate getCertificate(Principal subject)
            throws CAClientException;

}
