/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.caclient;

import org.glite.pseudo.common.pki.CertificateRequest;

/**
 * CARequest is an interface for the generic online CA server request.
 * 
 * Imported from org.glite.slcs.caclient.CARequest
 * 
 * @author Valery Tschopp <tschopp@switch.ch>
 */
public interface CARequest {

    /**
     * Depending of the request, adds a CertificateRequest to the request, or
     * set the CertificateRequest of the request.
     * 
     * @param csr
     *            The CertificateRequest to send as request
     */
    public void addCertificateRequest(CertificateRequest csr);

    /**
     * @return The DER encoded bytes of the CertificateRequest(s).
     */
    public byte[] getDEREncoded();

}
