/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.caclient;

import org.glite.pseudo.common.pki.CertificateRequest;

/**
 * CAConnection is a connection (session) to execute the request/response with
 * the online CA server.
 * 
 * Imported from org.glite.slcs.caclient.CAConnection
 * 
 * @author Valery Tschopp <tschopp@switch.ch>
 */
public interface CAConnection {

    /**
     * Creates a CARequest object for the given PKCS10 certificate request.
     * 
     * @param csr
     *            The certificate request to be send on the CAConnection.
     * @return The CARequest to be send.
     * @throws CAClientException
     *             If an error occurs while creating the request object.
     */
    public CARequest createRequest(CertificateRequest csr)
            throws CAClientException;

    /**
     * Sends a CARequest to the online CA server.
     * 
     * @param request
     *            The CARequest to send.
     * @throws CAClientException
     *             If an error occurs while sending or processing the request.
     */
    public void sendRequest(CARequest request) throws CAClientException;

    /**
     * Gets the CAResponse which is the result of the request.
     * 
     * @return The CAReponse or <code>null</code> if there were no request
     *         before.
     * @throws CAClientException
     *             If an error occurs while processing the response.
     */
    public CAResponse getResponse() throws CAClientException;

}
