/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.caclient;

/**
 * Place-holder for the exceptions related to the online CA client.
 */
public class CAClientException extends Exception {

    /** version ID */
    private static final long serialVersionUID = 2948490840656256369L;

    /**
     * Constructs a new <code>CAClientException</code>
     */
    public CAClientException() {
        super();
    }

    /**
     * Constructs a new <code>CAClientException</code>
     * 
     * @param string
     *            describing the exception.
     * @param e
     *            cause for the exception.
     */
    public CAClientException(String string, Exception e) {
        super(string, e);
    }

    /**
     * Constructs a new <code>CAClientException</code>
     * 
     * @param e
     *            cause for the exception.
     */
    public CAClientException(Exception e) {
        super(e);
    }

    /**
     * Constructs a new <code>CAClientException</code>
     * 
     * @param string
     *            describing the exception.
     */
    public CAClientException(String string) {
        super(string);
    }

}
