/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.caclient;

import org.glite.pseudo.server.PseudoServerComponent;

/**
 * Interface CAClient defines the operations needed for a generic online CA
 * client.
 * 
 * Imported from org.glite.slcs.caclient.CAClient
 * 
 * @author Valery Tschopp <tschopp@switch.ch>
 */
public interface CAClient extends PseudoServerComponent {

    /**
     * Returns the CAConnection (session) to process the request/response.
     * 
     * @return The connection the the CA server.
     * @throws CAClientException
     *             If an error occurs.
     */
    public CAConnection getConnection() throws CAClientException;

}
