/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor.impl;

import java.util.Date;

import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.glite.pseudo.server.auditor.AuditPersonEntry;

/**
 * <p>
 * Simple implementation for AuditEventEntry interface.
 * </p>
 * 
 * @author Henri Mikkonen &lt;henri.mikkonen@hip.fi&gt;
 */
public class AuditEventEntryImpl implements AuditEventEntry {

    /** Unique identifier for the event */
    private Long id;

    /** The type of the event */
    private int eventType;

    /** The level of the event */
    private int eventLevel;

    /** The date of the event */
    private Date eventDate;

    /** The message of the event */
    private String eventMessage;

    /** The remote address of the event */
    private String remoteAddress;

    /** The author of the event */
    private AuditPersonEntry eventAuthor;

    /**
     * <p>
     * Constructs an AuditEventEntryImpl.
     * </p>
     */
    public AuditEventEntryImpl() {
        // NO OP
    }

    // INTERFACE METHODS

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.audit.AuditEventEntry#getEventAuthor()
     */
    public AuditPersonEntry getEventAuthor() {
        return this.eventAuthor;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.audit.AuditEventEntry#getEventDate()
     */
    public Date getEventDate() {
        return this.eventDate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.audit.AuditEventEntry#getEventLevel()
     */
    public int getEventLevel() {
        return this.eventLevel;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.audit.AuditEventEntry#getEventMessage()
     */
    public String getEventMessage() {
        return this.eventMessage;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.audit.AuditEventEntry#getEventType()
     */
    public int getEventType() {
        return this.eventType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.glite.pseudo.audit.AuditEventEntry#getRemoteAddress()
     */
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    // METHODS FOR HIBERNATE

    /**
     * <p>
     * Gets the identifier.
     * </p>
     * 
     * @return the id
     */
    public Long getId() {
        return this.id;
    }

    /**
     * <p>
     * Sets the identifier.
     * </p>
     * 
     * @param id
     *            the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * <p>
     * Sets the event date.
     * </p>
     * 
     * @param date
     *            the date to set
     */
    public void setEventDate(Date date) {
        this.eventDate = date;
    }

    /**
     * <p>
     * Sets the event level.
     * </p>
     * 
     * @param level
     *            the level to set
     */
    public void setEventLevel(int level) {
        this.eventLevel = level;
    }

    /**
     * <p>
     * Sets the event message.
     * </p>
     * 
     * @param message
     *            the message to set
     */
    public void setEventMessage(String message) {
        this.eventMessage = message;
    }

    /**
     * <p>
     * Sets the event type.
     * </p>
     * 
     * @param type
     *            the type to set
     */
    public void setEventType(int type) {
        this.eventType = type;
    }

    /**
     * <p>
     * Sets the remote address.
     * </p>
     * 
     * @param address
     *            the remote address to set
     */
    public void setRemoteAddress(String address) {
        this.remoteAddress = address;
    }

    /**
     * <p>
     * Sets the event author.
     * </p>
     * 
     * @param eventAuthor
     *            the author to set
     */
    public void setEventAuthor(AuditPersonEntry eventAuthor) {
        this.eventAuthor = eventAuthor;
    }

    /**
     * <p>
     * Test whether an other instance is equal with this.
     * </p>
     * 
     * @param other
     *            the other instance
     * @return true if equal, false otherwise
     */
    public boolean equals(AuditEventEntryImpl other) {
        if (this == other)
            return true;
        if (!(other instanceof AuditEventEntry))
            return false;
        if (!other.getEventDate().equals(this.getEventDate()))
            return false;
        if (!other.getRemoteAddress().equals(this.getRemoteAddress()))
            return false;
        if (other.getEventLevel() != this.getEventLevel())
            return false;
        return true;
    }

}
