/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor.event;

import java.util.List;

import org.glite.pseudo.server.attribute.Attribute;

/**
 * <p>
 * PseudoAuditEvent is an audit event to be log be the Auditor.
 * </p>
 */
public class PseudoAuditEvent extends AuditEvent {

    /**
     * <p>
     * Constructor. Level is INFO.
     * </p>
     * 
     * @param message
     *            The event message.
     */
    public PseudoAuditEvent(int type, String message) {
        super(type, AuditEvent.LEVEL_INFO, message);
    }

    /**
     * <p>
     * Constructor. Level is INFO.
     * </p>
     * 
     * @param message
     *            The event message.
     * @param userAttributes
     *            The user information map.
     */
    public PseudoAuditEvent(int type, String message,
            List<Attribute> userAttributes) {
        super(type, AuditEvent.LEVEL_INFO, message, userAttributes);
    }

    /**
     * <p>
     * Constructor.
     * </p>
     * 
     * @param level
     *            The event level.
     * @param message
     *            The event message.
     */
    public PseudoAuditEvent(int type, int level, String message) {
        super(type, level, message);
    }

    /**
     * <p>
     * Constructor.
     * </p>
     * 
     * @param level
     *            The event level.
     * @param message
     *            The event message.
     * @param attributes
     *            The List of user Attribute.
     */
    public PseudoAuditEvent(int type, int level, String message,
            List<Attribute> userAttributes) {
        super(type, level, message, userAttributes);
    }

}
